'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit



Private Sub Button_Kundenkartei_Click()
On Error GoTo Err_Button_Kundenkartei_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Prfen, ob Rechnungstabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Kunden")
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Kundendaten von Outlook bernommen.", vbInformation, "Hinweis"
        Exit Sub
    End If
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    rst.Close
    Set dbs = Nothing
    
    'Rechnungsbuch ffnen
    FormularName = "Kunden"
    FormularBereich = "Rechnungen"
    KundenNrIntern = Me.lfd_Nr_Kunde.Value

    DoCmd.Close acForm, FormularName, acSaveNo
    DoCmd.OpenForm FormularName
    
    
Exit_Button_Kundenkartei_Click:
    Exit Sub

Err_Button_Kundenkartei_Click:
    MsgBox err.Description
    Resume Exit_Button_Kundenkartei_Click
    

End Sub

Private Sub Form_Current()
    'falls per Navigator der Datensatz gewechselt wird, Sucheld mit akt. Satz synchronisieren
    '   der folgende Befehl wurde am 22.02.2015 deaktiviert, weil neuerdings nach einem Wechsel des
    '   Datensatzes z. B. Navigator alle weiteren Aktionen auf den Buttons mit einer Meldung gesperrt sind:
    '   "Sie knnen diese Aktion im Moment nicht ausfhren!" (sinngem) und das Programm nicht mehr
    '   bedienbar ist und Access sich auch nicht schlieen lsst!
    'Me.Suchfeld.DefaultValue = Me.lfd_Nr.Value
    
    'Farbe des Datumsfeldes wechseln, je nach Druckstatus
    If Me.gedruckt.Value = True Then
        Me.Rechteck_Druckdatum.BorderStyle = 0      'unsichtbar
    Else
        Me.Rechteck_Druckdatum.BorderStyle = 1      'sichtbar (rot)
    End If
    
    'wenn Rechnung storniert, dann Hinweis anzeigen, ansonsten Hinweis verbergen
    If Me.Re_Storno = True Then
        Me.Storno_Rechteck.Visible = True
        Me.Storno_Hinweis.Visible = True
        Me.Storno_Datum.Visible = True
        Me.Storno_Linie.Visible = True
        Me.Storno_Grund.Visible = True
        If Me.Re_Storno_Art.Value = 1 Then
            Me.Storno_Art1_Text.Visible = True
            Me.Storno_Art2_Text.Visible = False
        End If
        If Me.Re_Storno_Art.Value = 2 Then
            Me.Storno_Art1_Text.Visible = False
            Me.Storno_Art2_Text.Visible = True
        End If
        Me.Stornobeleg_anzeigen.Visible = True
    Else
        Me.Storno_Rechteck.Visible = False
        Me.Storno_Hinweis.Visible = False
        Me.Storno_Datum.Visible = False
        Me.Storno_Linie.Visible = False
        Me.Storno_Grund.Visible = False
        Me.Storno_Art1_Text.Visible = False
        Me.Storno_Art2_Text.Visible = False
        Me.Stornobeleg_anzeigen.Visible = False
    End If
    
    'Stornomglichkeit der Rechnung vom Drucken und vorhandenem Storno abhngig
    Me.Rechnung_loeschen.Enabled = False
    If (Me.gedruckt.Value = True) And (Me.Re_Storno = False) Then Me.Rechnung_loeschen.Enabled = True
    
    'Marker fr Generalrckrechnung anzeigen/ausblenden
    If Me.Re_GRR.Value = True Then
        Me.Marker_Genenalrueckrechnung.Visible = True
    Else
        Me.Marker_Genenalrueckrechnung.Visible = False
    End If
    
    'MwSt-Splitting-Tabelle ein-/ausblenden
    If Me.Kasten_MwSt_Splitting.Value = True Then
        Me.Rechnungen_MwSt_Splitting.Visible = True
        Me.Re_MwSt_Bezeichnungsfeld.Caption = ReMwStKuerzel
    Else
        Me.Rechnungen_MwSt_Splitting.Visible = False
        Me.Re_MwSt_Bezeichnungsfeld.Caption = Format(Me.MwSt_Satz.Value, "#,##0.00") & " % " & ReMwStKuerzel
    End If
    
End Sub


Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'letzte erstellte Rechnung anzeigen
    Me.RecordsetClone.MoveLast
    Me.Bookmark = Me.RecordsetClone.Bookmark

    'bergebene laufende Rechnungsnummer auswerten und anzeigen
    Dim strRechnung As Variant
    
    strRechnung = Me.OpenArgs
    
    If Len(strRechnung) > 0 Then
        Me.Suchfeld.DefaultValue = strRechnung
        Suchfeld_AfterUpdate
    '    DoCmd.GoToControl "lfd_Nr"
    '    DoCmd.FindRecord strRechnung, , True, , True, , True
    End If
    
    'aktuelles Whrungsformat des Systems einstellen
    Me.Re_Netto.Format = "Currency"
    Me.Re_MwSt.Format = "Currency"
    Me.Re_Brutto.Format = "Currency"
End Sub

Private Sub gedruckt_AfterUpdate()
    If Me.gedruckt.Value = True Then
        Me.gedruckt_Bezeichnungsfeld.ForeColor = 0          'schwarz
    Else
        Me.gedruckt_Bezeichnungsfeld.ForeColor = 255        'rot
    End If
    
End Sub

Private Sub Formular_schliessen_Click()
On Error GoTo Err_Formular_schliessen_Click


    DoCmd.Close

Exit_Formular_schliessen_Click:
    Exit Sub

Err_Formular_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Formular_schliessen_Click
    
End Sub

Private Sub Rechnungsbuch_drucken_Click()
On Error GoTo Err_Rechnungsbuch_drucken_Click
    Dim dbs As Database, rst As Recordset
    
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Abf_Rech_SummeJahr")
    
    If (rst.RecordCount = 0) Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Keine Rechnungen vorhanden.", vbInformation, "Hinweis"
        Exit Sub
    End If
    
    rst.Close
    Set dbs = Nothing
    
    'Bericht ffnen
    TextEingabe = "Rechnungsbuch_Hauptformular"
    DoCmd.OpenForm "Rechnungsbuch_Jahreswahl", acNormal
        
    
Exit_Rechnungsbuch_drucken_Click:
    Exit Sub
    
Err_Rechnungsbuch_drucken_Click:
    MsgBox err.Description
    Resume Exit_Rechnungsbuch_drucken_Click

End Sub

Private Sub Rechnungsbuch_Kundensumme_Click()
On Error GoTo Err_Rechnungsbuch_Kundensumme_Click
    Dim dbs As Database, rst As Recordset
    
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Abf_Rech_SummeJahr")
    
    If (rst.RecordCount = 0) Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Keine Rechnungen vorhanden.", vbInformation, "Hinweis"
        Exit Sub
    End If
    
    rst.Close
    Set dbs = Nothing
    
    TextEingabe = "Rechnungsbuch_Kundenuebersicht"
    DoCmd.OpenForm "Rechnungsbuch_Jahreswahl", acNormal
        
    
Exit_Rechnungsbuch_Kundensumme_Click:
    Exit Sub
    
Err_Rechnungsbuch_Kundensumme_Click:
    MsgBox err.Description
    Resume Exit_Rechnungsbuch_Kundensumme_Click

End Sub

Private Sub Stornobeleg_anzeigen_Click()
On Error GoTo Err_Stornobeleg_anzeigen_Click
    Dim dbs As Database, rst As Recordset, qdf As QueryDef
    Dim strFilterRechnung, strFilterKunde, strFilterSteuer As String
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
        'Gre des Reportfensters und Berichts-Zoom optimieren
        'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
        AnwendungGroesseErmitteln
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    Set rst = Me.RecordsetClone
    
    'SQL-Texte vorbereiten
    strFilterRechnung = "SELECT * FROM Rechnungen WHERE Rechnungen.lfd_Nr=" & Me.lfd_Nr.Value
    strFilterKunde = "SELECT * FROM Kunden WHERE Kunden.lfd_Nr=" & Me.lfd_Nr_Kunde.Value
    strFilterSteuer = "SELECT * FROM Rechnungen_MwSt WHERE Rechnungen_MwSt.lfd_Nr_Re=" & Me.lfd_Nr.Value & " ORDER BY Rechnungen_MwSt.Prozent;"
    'vorhandene Abfragen erst lschen und mit neuem SQL-Text erstellen
    dbs.QueryDefs.Refresh
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungDaten"
    On Error GoTo Err_Stornobeleg_anzeigen_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungDaten", strFilterRechnung)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungKunde"
    On Error GoTo Err_Stornobeleg_anzeigen_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungKunde", strFilterKunde)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungMwSt"
    On Error GoTo Err_Stornobeleg_anzeigen_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungMwSt", strFilterSteuer)
    dbs.QueryDefs.Refresh
    'Rechnungsformular anzeigen
    On Error GoTo ERR_Formular
    DoCmd.OpenReport FormularStornoName, acPreview
ERR_Formular_weiter:
    On Error GoTo Err_Stornobeleg_anzeigen_Click
    
        'Berichtsfenster nun auf Anwendungsgre zoomen
        DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
        'Berichtsvorschau auf ganzes Blatt zoomen
        DoCmd.RunCommand acCmdFitToWindow
    
    'Tabellen schlieen
    qdf.Close
    rst.Close
    Set dbs = Nothing

Exit_Stornobeleg_anzeigen_Click:
    Exit Sub

Err_Stornobeleg_anzeigen_Click:
    MsgBox err.Description
    Resume Exit_Stornobeleg_anzeigen_Click
    
ERR_Formular:
    DoCmd.OpenReport "Storno_Hauptformular", acPreview
    Resume ERR_Formular_weiter
    
End Sub

Private Sub Suchfeld_AfterUpdate()
    ' Den mit dem Steuerelement bereinstimmenden Datensatz suchen.
    Me.RecordsetClone.FindFirst "[lfd_Nr] = " & Me![Suchfeld]
    Me.Bookmark = Me.RecordsetClone.Bookmark
End Sub
Private Sub Rechnungsvorschau_Click()
On Error GoTo Err_Rechnungsvorschau_Click
    Dim dbs As Database, rst As Recordset, qdf As QueryDef
    Dim strFilterRechnung, strFilterKunde, strFilterSteuer As String
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
        'Gre des Reportfensters und Berichts-Zoom optimieren
        'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
        AnwendungGroesseErmitteln
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    Set rst = Me.RecordsetClone
    
    'SQL-Texte vorbereiten
    strFilterRechnung = "SELECT * FROM Rechnungen WHERE Rechnungen.lfd_Nr=" & Me.lfd_Nr.Value
    strFilterKunde = "SELECT * FROM Kunden WHERE Kunden.lfd_Nr=" & Me.lfd_Nr_Kunde.Value
    strFilterSteuer = "SELECT * FROM Rechnungen_MwSt WHERE Rechnungen_MwSt.lfd_Nr_Re=" & Me.lfd_Nr.Value & " ORDER BY Rechnungen_MwSt.Prozent;"
    'vorhandene Abfragen erst lschen und mit neuem SQL-Text erstellen
    dbs.QueryDefs.Refresh
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungDaten"
    On Error GoTo Err_Rechnungsvorschau_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungDaten", strFilterRechnung)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungKunde"
    On Error GoTo Err_Rechnungsvorschau_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungKunde", strFilterKunde)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungMwSt"
    On Error GoTo Err_Rechnungsvorschau_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungMwSt", strFilterSteuer)
    dbs.QueryDefs.Refresh
    'Rechnungsformular anzeigen
    ReOriginal = False
    On Error GoTo ERR_Formular
    DoCmd.OpenReport FormularRechnungName, acPreview
ERR_Formular_weiter:
    On Error GoTo Err_Rechnungsvorschau_Click
    
    
        'Berichtsfenster nun auf Anwendungsgre zoomen
        DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
        'Berichtsvorschau auf ganzes Blatt zoomen
        DoCmd.RunCommand acCmdFitToWindow
    
    'Tabellen schlieen
    qdf.Close
    rst.Close
    Set dbs = Nothing

Exit_Rechnungsvorschau_Click:
    Exit Sub

Err_Rechnungsvorschau_Click:
    MsgBox err.Description
    Resume Exit_Rechnungsvorschau_Click
    
ERR_Formular:
    DoCmd.OpenReport "Rechnung_Hauptformular", acPreview
    Resume ERR_Formular_weiter
    
End Sub
Private Sub Rechnung_loeschen_Click()
On Error GoTo Err_Rechnung_loeschen_Click

    'gesperrte Jahren beachten
    If Me.Re_Jahr < KeineAenderungenVorJahrX Then
        MsgBox "Gem Ihren Einstellungen drfen keine Termine/Rechnungen der Jahre vor " & KeineAenderungenVorJahrX & " verndert werden.", vbCritical + vbOKOnly, "Jahr gesperrt"
        Exit Sub
    End If

    DoCmd.OpenForm "Rechnung_stornieren"

Exit_Rechnung_loeschen_Click:
    Exit Sub

Err_Rechnung_loeschen_Click:
    MsgBox err.Description
    Resume Exit_Rechnung_loeschen_Click
    
End Sub
Private Sub Rechnungsoriginal_drucken_Click()
On Error GoTo Err_Rechnungsoriginal_drucken_Click
    Dim dbs As Database, rst As Recordset, qdf As QueryDef
    Dim FilterRechnungen, strFilterRechnung, strFilterKunde, strFilterSteuer As String
    
    If MsgBox("Wollen Sie das Rechnungsoriginal jetzt drucken?", vbYesNo + vbDefaultButton2 + vbExclamation, "Rechnung drucken...") = vbNo Then Exit Sub
    
    'Eigenen Formularnamen merken fr Aktualisierung,
    'falls Druckmarkierung gendert (gesetzt) wird
    FormularName = "Rechnungen_Uebersicht"
    ReNrIntern = Me.lfd_Nr.Value
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    FilterRechnungen = "SELECT * FROM Rechnungen WHERE ([lfd_Nr]=" & Me.lfd_Nr.Value & ")"
    Set rst = dbs.OpenRecordset(FilterRechnungen)
    
    'SQL-Texte vorbereiten
    strFilterRechnung = "SELECT * FROM Rechnungen WHERE Rechnungen.lfd_Nr=" & Me.lfd_Nr.Value
    strFilterKunde = "SELECT * FROM Kunden WHERE Kunden.lfd_Nr=" & Me.lfd_Nr_Kunde.Value
    strFilterSteuer = "SELECT * FROM Rechnungen_MwSt WHERE Rechnungen_MwSt.lfd_Nr_Re=" & Me.lfd_Nr.Value & " ORDER BY Rechnungen_MwSt.Prozent;"
    'vorhandene Abfragen erst lschen und mit neuem SQL-Text erstellen
    dbs.QueryDefs.Refresh
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungDaten"
    On Error GoTo Err_Rechnungsoriginal_drucken_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungDaten", strFilterRechnung)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungKunde"
    On Error GoTo Err_Rechnungsoriginal_drucken_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungKunde", strFilterKunde)
    On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
    dbs.QueryDefs.Delete "Abf_RechnungMwSt"
    On Error GoTo Err_Rechnungsoriginal_drucken_Click        'Fehlerbehandlung wieder einschalten
    Set qdf = dbs.CreateQueryDef("Abf_RechnungMwSt", strFilterSteuer)
    dbs.QueryDefs.Refresh
    'Rechnung ausdrucken
    ReOriginal = True
    RechnungZumDrucker
    'Markierung und Datum setzen und Ansicht aktualisieren
    If rst!gedruckt <> True Then
        'nur beim ersten Druck dieser Rechnung das Datum merken
        rst.Edit
        rst!gedruckt = True
        rst!Re_Druckdatum = Now()
        rst.Update
        rst.Bookmark = rst.LastModified
    End If
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    DoCmd.OpenForm "Rechnungen_Uebersicht", , , , , , ReNrIntern
    
'    Me.Requery
'    Me.Bookmark = rst.Bookmark
'    Me.Refresh
    'Tabellen schlieen
    qdf.Close
    rst.Close
    Set dbs = Nothing

Exit_Rechnungsoriginal_drucken_Click:
    Exit Sub

Err_Rechnungsoriginal_drucken_Click:
    MsgBox err.Description
    Resume Exit_Rechnungsoriginal_drucken_Click
    
End Sub

